<?php
/**
* Author: DragonFever
* Copyright: © 2008 DragonFever
* Website:  http://www.dragonfever.info
**/

// Disallow direct access to this file for security reasons
if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

// Plugin hook
$plugins->add_hook("parse_message", "hidelinks_hide");

// Plugin info
function hidelinks_info()
{
	return array(
		"name"			=> "هاك اخفاء الروابط عن الزوار",
		"description"	=> "يقوم باخفاء الروابط عن الزوار واظهار رساله تفيد بذلك.",
		"website"		=> "http://www.dragonfever.info",
		"author"		=> "DragonFever",
		"authorsite"	=> "http://www.dragonfever.info",
		"version"		=> "1.0",
		"guid"			=> "d424f74b9c2e851a6b9aea25de43598b",
		"compatibility" => "16*"
	);

}

// Activate plugin
function hidelinks_activate()
{
	global $db;

	$hidelinks_group = array(
		"gid"			=> "NULL",
		"name"			=> "hidelinks_settings",
		"title" 		=> "هاك اخفاء الروابط عن الزوار",
		"description"	=> "اعدادات الهاك.",
		"disporder"		=> "100",
		"isdefault"		=> "no",
	);
	$db->insert_query("settinggroups", $hidelinks_group);
	$gid = $db->insert_id();
	
	$hidelinks_setting_1 = array(
		"sid"			=> "NULL",
		"name"			=> "hidelinks_enabled",
		"title"			=> "تفعيل / تعطيل ",
		"description"	=> "تستطيع تفعيل او تعطيل الهاك من هنا",
		"optionscode"	=> "yesno",
		"value"			=> "no",
		"disporder"		=> "1",
		"gid"			=> intval($gid),
	);
		
    $hidelinks_setting_2 = array(
        "sid"			=> "NULL",
        "name"			=> "hidelinks_message",
        "title"			=> "الرساله",
        "description"	=> "ادخل الرساله التي سوف تظهر للزائر وتستطيع استخدام HTML",
        "optionscode"	=> "textarea",
        "value"			=> "<font color=\"red\">نعتذر لن تستطيع مشاهدة الروابط لانك زائر قم بالتسجيل من<a href=\"member.php?action=register\"><strong>هنا</strong></a> لكي تستطيع مشاهدة الروابط</font>",
        "disporder"		=> "5",
        "gid"			=> intval($gid),
        );
	
	$db->insert_query("settings", $hidelinks_setting_1);
	$db->insert_query("settings", $hidelinks_setting_2);
	
	// Optimizing database
	$db->query("OPTIMIZE TABLE ".TABLE_PREFIX."settinggroups");
	$db->query("OPTIMIZE TABLE ".TABLE_PREFIX."settings");
	$db->query("OPTIMIZE TABLE ".TABLE_PREFIX."sessions");
	
	// Rebuilding settings
    rebuildsettings();
}

// Deactivate plugin
function hidelinks_deactivate()
{
	global $db;

	$db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name='hidelinks_settings'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='hidelinks_enabled'");
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name='hidelinks_message'");
	
	// Optimizing database
	$db->query("OPTIMIZE TABLE ".TABLE_PREFIX."settinggroups");
	$db->query("OPTIMIZE TABLE ".TABLE_PREFIX."settings");
	$db->query("OPTIMIZE TABLE ".TABLE_PREFIX."sessions");
	
	// Rebuilding settings
    rebuildsettings();
}

// Run plugin
function hidelinks_hide(&$message)
{
	global $settings, $mybb;
	
	if ($mybb->settings['hidelinks_enabled'] == "1")
	{
		if($mybb->user['usergroup'] == "1")
		{
			$message = preg_replace("!<a[^>]*(http|www)(.*)</a>!siU", "{$mybb->settings['hidelinks_message']}", $message);
		}
	}
}
?>